package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import flash.events.MouseEvent;
	
	import se.qmd.spaceInvaders.GunBullets.GunBullet;
	import se.qmd.spaceInvaders.ShipHandler;
	import se.qmd.spaceInvaders.LeGun;
	import se.qmd.starLight.StarHandler;
	import se.qmd.spaceInvaders.GameOver;
	
	/**
	 * ...
	 * @author PQ
	 */
	public class Main extends Sprite {
		
		private var _leGun:LeGun;
		private var _leftMoveBool:Boolean;
		private var _rightMoveBool:Boolean;
		private var _spaceHitBool:Boolean;
		
		private var _starHandler:StarHandler;
		private var _shipHandler:ShipHandler;
		
		private var _gunBulletArray:Array = [];
		
		private var _startGame:WelcomeStart;
		private var _gameOver:GameOver;
		
		//private var _bulletTimer:Timer;
		private var _scoreTimer:Timer;
		private var _theTime:int;
		private var _theScore:int;
		
		public function Main():void {

				initGraphics();
		}
		
		private function onEnterFrame(e:Event):void {
			
			if (_leGun.x > stage.stageWidth - _leGun.width / 2) {
				
				_leGun.x = _leGun.width / 2;
			}
			
			if (_leGun.x < _leGun.width / 2) {
				
				_leGun.x = stage.stageWidth - _leGun.width / 2;
			}
			
			if (_leftMoveBool) {
				
				_leGun.x -= 10;
				_leGun.canonWheel.rotation -= 18;
			}
			
			if (_rightMoveBool) {
				
				_leGun.x += 10;
				_leGun.canonWheel.rotation += 18;
			}
			
			var shipArray:Array = _shipHandler.getShips();
			if (shipArray.length < 1) {
				
				removeBullets();
				gameOver();
			}
			
			/* if (_spaceHitBool) {
				
				var shipArray:Array = _shipHandler.getShips();
				stage.addChild(new GunBullet(_leGun.x, this.stage, shipArray));
			} */
		}
		
		private function onKeyUp(e:KeyboardEvent):void {
			
			switch (e.keyCode) {
				case 37 :
					_leftMoveBool = false;					
				break;				
				case 39 :
					_rightMoveBool = false;					
				break;				
				/* case 32 :
					_spaceHitBool = false;					
				break; */
			}
		}
		
		private function onKeyDown(e:KeyboardEvent):void {
			
			switch (e.keyCode) {
				case 37 :
					_leftMoveBool = true;					
				break;				
				case 39 :
					_rightMoveBool = true;					
				break;				
				case 32 :
					//_spaceHitBool = true;	
					newBullet();
				break;
			} 
		}
		
		private function initGraphics():void {
			
			_starHandler = new StarHandler(this.stage);  // skickar stage till starhandler class			
			_starHandler.x = 0;
			_starHandler.y = 0;
			this.addChild(_starHandler);
			
			_startGame = new WelcomeStart();
			_startGame.x = 200;
			_startGame.y = 150;
			this.addChild(_startGame);
			_startGame.goBtn.buttonMode = true;
			_startGame.goBtn.addEventListener(MouseEvent.CLICK, startTheGame);			
		}		
		
		private function startTheGame(e:Event):void {
			
			_startGame.goBtn.removeEventListener(MouseEvent.CLICK, startTheGame);
			this.removeChild(_startGame);
			
			_leGun = new LeGun();
			_leGun.x = stage.stageWidth / 2;
			_leGun.y = stage.stageHeight - _leGun.height/2 -5;
			this.addChild(_leGun);			
			
			_shipHandler = new ShipHandler(this.stage);
			_shipHandler.x = 0;
			_shipHandler.y = 0;
			this.addChild(_shipHandler);
			
			_theTime = 20;
			_theScore = 100;
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			_scoreTimer = new Timer(1000, 20);
			_scoreTimer.start();
			_scoreTimer.addEventListener(TimerEvent.TIMER, onTimerChange);
			_scoreTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onGameTimeUp);
		}
		
		private function onTimerChange(e:TimerEvent):void {
			
			_theTime -= 1;
			_theScore -= 5;
			theTime.text = _theTime.toString();
			theScore.text = _theScore.toString();
		}
		
		private function onGameTimeUp(e:TimerEvent):void {
			
			_shipHandler.removeShips();
			gameOver();
		}
		
		private function gameOver():void {
			
			_scoreTimer.stop();
			this.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.removeEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.removeEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			_scoreTimer.removeEventListener(TimerEvent.TIMER, onTimerChange);
			this.removeChild(_leGun);
			this.removeChild(_shipHandler);
			
			_gameOver = new GameOver();
			_gameOver.x = 200;
			_gameOver.y = 35;
			this.addChild(_gameOver);
			_gameOver.addBtn.buttonMode = true;
			_gameOver.goAgainBtn.buttonMode = true;
			_gameOver.endScore.text = _theScore.toString();
			_gameOver.goAgainBtn.addEventListener(MouseEvent.CLICK, playAgain);
		}
		
		private function playAgain(e:MouseEvent):void {
			
			_gameOver.addBtn.enabled = true;
			_gameOver.addBtn.removeEventListener(MouseEvent.CLICK, startTheGame);
			_gameOver.goAgainBtn.removeEventListener(MouseEvent.CLICK, playAgain);
			this.removeChild(_gameOver);

			this.addChild(_startGame);
			_startGame.goBtn.addEventListener(MouseEvent.CLICK, startTheGame);
		}
		
		private function removeBullets():void {
			
			for (var i:int = 0; i < _gunBulletArray.length; i++) {
				
				var gunBullet:GunBullet = _gunBulletArray[i];
				gunBullet.removeBullet();
			}
			_gunBulletArray.length = 0;
		}
		
		private function newBullet():void {
			
			var shipArray:Array = _shipHandler.getShips();
			var gunBullet:GunBullet = new GunBullet(_leGun.x, this.stage, shipArray);
			stage.addChild(gunBullet);
			_gunBulletArray.push(gunBullet);
		}
	}	
}