package se.qmd.spaceInvaders.GunBullets {
	
	import flash.display.MovieClip;
	import flash.display.Stage;
	import flash.events.Event;

	
	/**
	 * ...
	 * @author PQ
	 */
	public class GunBullet extends MovieClip {
		
		private var _speed:Number = 12;
		private var s:Stage = null;
		private var _shipArray:Array;
		
		public function GunBullet(xPos:Number, o:Stage, shipArray) {
			
			_shipArray = shipArray;
			s = o; // tar emot stage från main
			this.x = xPos;
			this.y = s.stageHeight - 60;			
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}		
		
		private function onEnterFrame(e:Event):void {
			
			this.y -= _speed;
			
			for (var i:int = 0; i < _shipArray.length; i++) {
				
				if (this.hitTestObject(_shipArray[i])) {
					
					destroy(i);					
				}				
			}
			
			if (this.y < 50) {
				
				destroy(-1);
			}
		}
		
		public function destroy(shipNumber:int): void {
			
			if (parent) {
				
				parent.removeChild(this);
			}
			if (shipNumber > -1) {
				
				s.removeChild(_shipArray[shipNumber]);
				_shipArray.splice(shipNumber, 1);
			}
 
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		public function removeBullet():void {
			
			if (parent) {
				
				parent.removeChild(this);
			}
		}

	}
}