package se.qmd.spaceInvaders {
	
	import flash.display.MovieClip;
	import se.qmd.spaceInvaders.Ship;
	import flash.display.Stage;
	import flash.events.Event;
	
	/**
	 * ...
	 * @author PQ
	 */
	public class ShipHandler extends MovieClip {
		
		private var _shipArray:Array = [];
		private const NUM_START_SHIPS:int = 25;
		private var s:Stage = null;
		
		private var _directionX:Number = 1;
		private var _directionY:Number = 1;
		private var _velocityX:Number;
		private var _velocityY:Number;
		
		private const YBORDER_TOP:int = 50;
		private const YBORDER_BOTTOM:int = 525;
		
		public function ShipHandler(o:Stage) {
			
			s = o; // tar emot stage från main
			createObjects();
			
			this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}	
		
		private function createObjects():void {
			
			for (var i:int = 0; i < NUM_START_SHIPS; i++) {
				
				var aShip:Ship = new Ship();
				aShip.x = Math.random() * (s.stageWidth - aShip.width) + aShip.width / 2;
				aShip.y = Math.random() * (s.stageHeight - aShip.height -135) + aShip.height / 2 + 55;
				s.addChild(aShip);
				_shipArray.push(aShip);
				aShip.startMove(Math.random(), Math.random());
			}			
		}	
		
		private function onEnterFrame(e:Event):void {
			
			for (var i:int = 0; i < _shipArray.length; i++) {				
				
				var aShip:Ship = _shipArray[i];
				aShip.update();
			}	
		}
		
		public function getShips():Array {
			
			return _shipArray;
		}
		
		public function removeShips():void {
			
			for (var i:int = 0; i < _shipArray.length; i++) {
				
				stage.removeChild(_shipArray[i]);				
			}
			_shipArray.length = 0;
		}
	}
}