package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.net.URLRequest;
	import flash.net.navigateToURL;
	import flash.utils.Timer;
	import se.qmd.spaceInvaders.ShipHandler;
	import se.qmd.starLight.StarHandler;
	
	/**
	 * ...
	 * @author PQ
	 */
	public class Main extends Sprite {
		
		private var _starHandler:StarHandler;
		private var _shipHandler:ShipHandler;
		
		private var _clickBtn:ClickBtn;
		private var _playItTxt:PlayItTxt;
		private var _spaceInvadersTxt:SpaceInvadersTxt;
		
		private var _playItTimer:Timer;
		private var _spaceInvadersTimer:Timer;
		
		private var _playItCounter:uint = 0;
		private var _spaceInvadersCounter:uint = 0;
		
		private var _theUrl:URLRequest;
		
		public function Main():void {
			
			_starHandler = new StarHandler(this.stage);
			_starHandler.x = 0;
			_starHandler.y = 0;
			this.addChild(_starHandler);
			
			_shipHandler = new ShipHandler(this.stage);
			_shipHandler.x = 0;
			_shipHandler.y = 0;
			this.addChild(_shipHandler);
			
			_spaceInvadersTxt = new SpaceInvadersTxt();
			_spaceInvadersTxt.x = stage.stageWidth / 2 - _spaceInvadersTxt.width / 2;
			_spaceInvadersTxt.y = stage.stageHeight / 6;
			_spaceInvadersTxt.alpha = 0;
			this.addChild(_spaceInvadersTxt);
			
			_playItTxt = new PlayItTxt();
			_playItTxt.x = stage.stageWidth / 2 - _playItTxt.width / 2;
			_playItTxt.y = stage.stageHeight * 3 / 5;
			_playItTxt.alpha = 0;
			this.addChild(_playItTxt);
			
			_clickBtn = new ClickBtn();
			_clickBtn.x = 0;
			_clickBtn.y = 0;
			this.addChild(_clickBtn);
			_clickBtn.addEventListener(MouseEvent.CLICK, onBannerClick);
			
			_spaceInvadersTimer = new Timer(100, 75);
			_spaceInvadersTimer.start();
			_spaceInvadersTimer.addEventListener(TimerEvent.TIMER, onSpaceInvadersTimerChange);
			
			_playItTimer = new Timer(100, 75);
			_playItTimer.start();
			_playItTimer.addEventListener(TimerEvent.TIMER, onPlayItTimerChange);
		}		
		
		private function onSpaceInvadersTimerChange(e:TimerEvent):void {
			
			_spaceInvadersCounter++;
			if (_spaceInvadersCounter > 4 && _spaceInvadersTxt.alpha < 1) {
				
				_spaceInvadersTxt.alpha += 0.05;
				trace(_spaceInvadersTxt.alpha);
			}
		}
		
		private function onPlayItTimerChange(e:TimerEvent):void {
			
			_playItCounter++;
			if (_playItCounter > 8 && _playItTxt.alpha < 1) {
				
				_playItTxt.alpha += 0.05;
				trace(_playItTxt.alpha);
			}
		}
		
		private function onBannerClick(e:MouseEvent):void {
			
			_theUrl = new URLRequest(root.loaderInfo.parameters.clickTAG);
			navigateToURL(_theUrl, "_blank");
		}
	}	
}