package se.qmd.spaceInvaders {
	
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.display.Stage;
	
	/**
	 * ...
	 * @author PQ
	 */
	public class Ship extends MovieClip {
		
		private var _directionX:Number = 1;
		private var _directionY:Number = 1;
		private var _velocityX:Number;
		private var _velocityY:Number;
		
		private const YBORDER_TOP:int = 50;
		private const YBORDER_BOTTOM:int = 525;
		//private var s:Stage = null;
		
		public function Ship() {
			
			//s = o; // tar emot stage
			this.width = 50;
			this.height = 18;	
			this.addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
		}
		
		private function onAddedToStage(e:Event):void {
			
			removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
			
			this.width = 50;
			this.height = 18;			
		}
		
		public function update():void {
			
			// x led vänster kant
			if(this.x <= this.width / 2) {
				
				this.x = this.width / 2;
				_directionX *= -1;
			}
			
			// x led höger kant
			if(this.x >= 800 - this.width / 2) {
				
				this.x = 800 - this.width/2;
				_directionX *= -1;
			}
			
			// y led top kant
			if(this.y <= YBORDER_TOP + this.height/2) {
				
				this.y = YBORDER_TOP + this.height / 2;
				_directionY *= -1;
			}
			
			// y led botten kant
			if(this.y >= YBORDER_BOTTOM - this.height/2) {
				
				this.y = YBORDER_BOTTOM - this.height / 2;
				_directionY *= -1;
			}
			
			this.x += _velocityX * _directionX;
			this.y += _velocityY * _directionY;
		}
		
		public function startMove(directionX:Number, directionY:Number):void {
			
			_velocityX = 5;
			_velocityY = 5;
			
			if (directionX < 0.5) {
				
				_directionX = -1;
			}
			
			if (directionY < 0.5) {
				
				_directionY = -1;
			}
		}
		
		public function changeDirection():void {
			
			_directionX *= -1;
			_directionY *= -1;
		}	
	}
}