package se.qmd.starLight {
	
	import flash.display.Sprite;
	import flash.events.Event;
	import com.greensock.TweenMax;
	import com.greensock.easing.*;
	import flash.display.Stage;
	
	public class StarHandler extends Sprite {
		
		private const NUM_PARTICLES:int = 50;		
		private var _particles:Array = new Array();
		private var _particleBoolean:Array = new Array();
		private var s:Stage = null;
		
		public function StarHandler(o:Stage) {
			
			s = o; // tar emot stage från main
			createParticles();
			
			this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function createParticles():void {
			
			for (var i:uint = 0; i < NUM_PARTICLES; i++) {
				
				var star:Stars = new Stars();
				var startAlpha:Number = Math.random();
				var particle:Particle = new Particle(star);
				var randomSize:Number = Math.random() * 0.5;
				
				this.addChild(particle);
				particle.alpha = startAlpha;
				particle.width *= randomSize;
				particle.height *= randomSize;
				particle.x = Math.random() * (s.stageWidth - particle.width) + particle.width / 2;
				particle.y = Math.random() * (s.stageHeight - particle.height) + particle.height / 2;
				_particles.push(particle);
				_particleBoolean[i] = true;
			}
		}
		
		private function onEnterFrame(p_evt:Event):void {
			
			for (var i:uint = 0; i < _particles.length; i++) {
				
				var particle:Particle = _particles[i];
				var tweenTime:Number = Math.random() * 2 + 1.5;
				var delayTime:Number = Math.random() * 10;
				var scaled:Number = Math.random() * 0.9;
				if (_particleBoolean[i]) {
					
					_particleBoolean[i] = false;
					TweenMax.to(particle, tweenTime, { scaleX:scaled, scaleY:scaled, alpha:1, delay:delayTime, onComplete:tweenComplete(i) } );
					//trace("Onenterframe: ", _particleBoolean[i],  i );
				}							
			}			
		}	
		
		private function tweenComplete(particleNum:uint):void {
			
			var particle:Particle = _particles[particleNum];
			var tweenTime:Number = Math.random() * 2 + 1.5;
			var delayTime:Number = Math.random() * 10;
			
			TweenMax.to(particle, tweenTime, { scaleX:0, scaleY:0,alpha:0,delay:delayTime, onComplete:changeBool(particleNum) } );
		}
		
		private function changeBool(particleNum:uint):void {
			
			_particleBoolean[particleNum] = true;
			//trace("changeBool: ", _particleBoolean[particleNum], particleNum );
			//trace("---------------------------------------------");
		}
	}
}