package {
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import mx.rpc.AbstractOperation;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.soap.LoadEvent;
	import mx.rpc.soap.WebService;
	
	/**
	 * ...
	 * @author PQ
	 */
	public class Main extends MovieClip {
		
		private var weatherWebService:WebService;
		private var serviceOperation:AbstractOperation;
		
		public function Main():void {
			
			clickMe.addEventListener(MouseEvent.CLICK, SetupWebService);
		}	
		
		private function SetupWebService(e:MouseEvent):void {
			
			weatherWebService = new WebService();
			weatherWebService.loadWSDL("http://www.webservicex.net/globalweather.asmx?WSDL");
			weatherWebService.addEventListener(LoadEvent.LOAD, BuildServiceRequest);
			
		}
		
		private function BuildServiceRequest(e:LoadEvent):void {
			
			serviceOperation = weatherWebService.getOperation("GetWeather");			
			serviceOperation.addEventListener(FaultEvent.FAULT, DisplayError);
			serviceOperation.addEventListener(ResultEvent.RESULT, DisplayResult);
			serviceOperation.send(theCity.text, theCountry.text);
		}
		
		private function DisplayError(e:FaultEvent) {
			theResult.text = "Totalfiasko!";
		}
		
		private function DisplayResult(e:ResultEvent) {
			var theXML = new XML(e.result);
			theResult.text = theXML.Location + ": " + theXML.Temperature;
		}
	}	
}